package imi.pmf.sprint;

import java.util.ArrayList;
import java.util.List;

public class AktvniSprint {
    private List<Osoba> ucesnici = new ArrayList<>();
    private List<Zadatak> zadaci = new ArrayList<>();

    private ZadaciNaCekanju zadaciNaCekanju;
    private Zaposleni zaposleni;

    public String dodajZadatakUAktivniSprint(String nazivZadatak, String imeOsobe){
        for (Zadatak zadatak: zadaci){
            if (zadatak.getNaziv().equalsIgnoreCase(nazivZadatak))
                return "Zadatak je vec uvrsten u aktivni sprint.";
        }

        Zadatak zadatak = zadaciNaCekanju.preuzmiZadatakPoNazivu(nazivZadatak);
        if (zadatak == null)
            return "Trazeni zadatak nije pronadjen";

        for (Osoba o : ucesnici){
            if (o.getIme().equalsIgnoreCase(imeOsobe)){
                zadatak.setDodeljenOsobi(o);
                break;
            }
        }

        if (zadatak.getDodeljenOsobi() == null){
            Osoba osoba = zaposleni.pronadjiOsobuPoImenu(imeOsobe);
            if (osoba != null){
                if (osoba.getPozicija().equalsIgnoreCase("inzenjer")){
                    zadatak.setDodeljenOsobi(osoba);
                    ucesnici.add(osoba);
                }
            }
            else {
                return "Nije pronadjena osoba sa trazenim imenom.";
            }
        }

        zadaci.add(zadatak);
        return "Zadatak je uspeno dodeljen.";
    }


}
